# 객체 지향 프로그래밍(Object-Oriented Programming)
## 객체 지향 프로그래밍이란?
**OOP(Object Oriendted Programming)**  이라고도 부르며, 프로그램을 여러 개의 독립된 객체들과 그 객체들 간의 상호작용을 이용한 프로그래밍 접근법이다.  

- 객체지향 프로그램을 만들기 위해서 고려해야할 것들  
    - 프로그램에 어떤 객체들이 필요한지 정한다.  
    - 객체들의 속성과 행동들을 정한다.  
    - 객체들이 서로 어떻게 소통해야할지 정한다.  

사용되는 대표적인 언어: Java, C++, Python, Swift 등등

## 객체 지향 프로그래밍의 핵심 개념

1. **추상화(Abstraction)**    
    - 이름 잘 짓고, 문서화 잘하기  
    - 구조를 상세히 몰라도, 클래스나 메서드, 변수들의 이름만으로 파악할 수 있어야 한다.
2. **캡슐화(Encapsulation)**    
    - 외부로부터의 직접적인 액세스 차단한다. ( ex) getter / setter, private 제어자 )  
    - 속성과 이 속성을 사용하는 행동을 하나로 묶어야 한다. (객체를 사용할 땐 메서드를 사용)  
3. **상속(Inheritance)**    
    - 중복되는 코드는 상속받는다. (중복되는 코드가 있다면 부모클래스를 만들어 override함)  
4. **다형성(Polymophism)**   
    - 오버로딩(overloading) - 같은이름의 함수를 매개변수의 타입, 갯수를 다르게하여 재정의한 것  
    - 오버라이딩(overriding) - 부모클래스에서 정의한 메서드와 같은 이름, 같은 매개변수를 갖는 메서드를 자식클래스에서 재정의한 것  
    - 사실 여기가 디따 중요한데, Spring 관련 내용 채우면서 마저 하겠습니다 커밍쑨


## 객체 지향 프로그래밍의 기본 구성 요소
- **클래스 (Class)**  
    - 같은 종류의 집단에 속하는 속성과 행위를 정의한 것,
    - 다른 클래스와 독립적으로 디자인해야한다.
- **객체 (Object)**
    - 클래스의 인스턴스이며, 상위 클래스의 속성과 개별적인 특성과 행위(메서드)를 가지고 있다.
- **메서드 (Method)**
    - 클래스로부터 생성된 객체를 사용하는 방법이며, 객체의 속성을 조작하는데에 사용된다.


## 객체 지향 프로그래밍의 장점과 단점
**장점**  
코드의 재사용이 용이하다  
유지보수 및 업그레이드가 쉽다.  
대형 프로젝트에 효과적이다.  
직관적인 코드 분석을 가능하게 한다.  

**단점**  
처리속도가 느리다.  
객체가 많아질수록 용량이 커진다.  
설계 시 시간과 노력이 많이 필요하다.  

